using System;
using System.Linq;

namespace SupplementaryAreaPlugin.Shared;

internal static class ValidationHelpers
{
    public static bool IsValidJsonPayloadSize(string? body, int max) => string.IsNullOrEmpty(body) || body!.Length <= max;
    public static bool IsValidStringLength(string? value, int max) => string.IsNullOrEmpty(value) || value!.Length <= max;
    public static bool IsValidRecordId(string? recordId, int maxLen = 100)
    {
        if (string.IsNullOrWhiteSpace(recordId) || recordId!.Length > maxLen) return false;
        return recordId.All(c => char.IsLetterOrDigit(c) || c == '-' || c == '_' || c == '.');
    }
}